%% Generating the gaussian distribution for the moving parameters
x = [0.00317565500000000	0.00430400000000000	0.00249114900000000	0.0767309010000000	0.350846930000000	0.0882344960000000	0.000515437800000000	47.9000000000000	43	29.7917707500000	7.50236352600000	0.274458610000000	14.0877890200000	16.4625903900000	15.2474697800000	10.3678571500000	14.2160781250000	0.00244956000000000	0.00514753440000000	0.0100000000000000	0.00722766000000000	0.0288161260000000	0.309924890000000	0.00817096660000000	0.0826584950000000];

figure(1)
sgtitle('Gaussian Distributions of Moving Probabilities Across Tissues', ...
        'FontName', 'Times New Roman', ...
        'FontSize', 12, ...
        'FontWeight', 'bold');
subplot(4,2,1)
mu = x(1); sigma = x(19);
val = linspace(mu - 3*sigma, mu + 3*sigma, 471);
pdf = (1 / (sigma * sqrt(2*pi))) * exp(-0.5 * ((val - mu)/sigma).^2);
plot(val, pdf, 'LineWidth', 2)
xlabel('P_{b\rightarrowLLNs}','FontName','Times New Roman','FontSize',10)
ylabel('PDF','FontName','Times New Roman','FontSize',10)
set(gca,'FontName','Times New Roman','FontSize',10)
xlim([0 inf]); grid on
cdf_vals_LLNs = normcdf(val, mu, sigma);

subplot(4,2,2)
mu = x(2); sigma = x(20);
val = linspace(mu - 3*sigma, mu + 3*sigma, 471);
pdf = (1 / (sigma * sqrt(2*pi))) * exp(-0.5 * ((val - mu)/sigma).^2);
plot(val, pdf, 'LineWidth', 2)
xlabel('P_{b\rightarrowMLNs}','FontName','Times New Roman','FontSize',10)
ylabel('PDF','FontName','Times New Roman','FontSize',10)
set(gca,'FontName','Times New Roman','FontSize',10)
xlim([0 inf]); grid on
cdf_vals_MLNs = normcdf(val, mu, sigma);

subplot(4,2,3)
mu = x(3); sigma = x(21);
val = linspace(mu - 3*sigma, mu + 3*sigma, 471);
pdf = (1 / (sigma * sqrt(2*pi))) * exp(-0.5 * ((val - mu)/sigma).^2);
plot(val, pdf, 'LineWidth', 2)
xlabel('P_{b\rightarrowSLNs}','FontName','Times New Roman','FontSize',10)
ylabel('PDF','FontName','Times New Roman','FontSize',10)
set(gca,'FontName','Times New Roman','FontSize',10)
xlim([0 inf]); grid on
cdf_vals_SLNs = normcdf(val, mu, sigma);

subplot(4,2,4)
mu = x(4); sigma = x(22);
val = linspace(mu - 3*sigma, mu + 3*sigma, 471);
pdf = (1 / (sigma * sqrt(2*pi))) * exp(-0.5 * ((val - mu)/sigma).^2);
plot(val, pdf, 'LineWidth', 2)
xlabel('P_{b\rightarrowRP}','FontName','Times New Roman','FontSize',10)
ylabel('PDF','FontName','Times New Roman','FontSize',10)
set(gca,'FontName','Times New Roman','FontSize',10)
xlim([0 inf]); grid on
cdf_vals_RP = normcdf(val, mu, sigma);

subplot(4,2,5)
mu = x(5); sigma = x(23);
val = linspace(mu - 3*sigma, mu + 3*sigma, 471);
pdf = (1 / (sigma * sqrt(2*pi))) * exp(-0.5 * ((val - mu)/sigma).^2);
plot(val, pdf, 'LineWidth', 2)
xlabel('P_{b\rightarrowROB}','FontName','Times New Roman','FontSize',10)
ylabel('PDF','FontName','Times New Roman','FontSize',10)
set(gca,'FontName','Times New Roman','FontSize',10)
xlim([0 inf]); grid on
cdf_vals_ROB = normcdf(val, mu, sigma);

subplot(4,2,6)
mu = x(6); sigma = x(24);
val = linspace(mu - 3*sigma, mu + 3*sigma, 471);
pdf = (1 / (sigma * sqrt(2*pi))) * exp(-0.5 * ((val - mu)/sigma).^2);
plot(val, pdf, 'LineWidth', 2)
xlabel('P_{RP\rightarrowWP}','FontName','Times New Roman','FontSize',10)
ylabel('PDF','FontName','Times New Roman','FontSize',10)
set(gca,'FontName','Times New Roman','FontSize',10)
xlim([0 inf]); grid on
cdf_vals_RP_WP = normcdf(val, mu, sigma);

subplot(4,2,7)
mu = x(7); sigma = x(25);
val = linspace(mu - 3*sigma, mu + 3*sigma, 471);
pdf = (1 / (sigma * sqrt(2*pi))) * exp(-0.5 * ((val - mu)/sigma).^2);
plot(val, pdf, 'LineWidth', 2)
xlabel('P_{RP\rightarrowb}','FontName','Times New Roman','FontSize',10)
ylabel('PDF','FontName','New Roman','FontSize',10)
set(gca,'FontName','Times New Roman','FontSize',10)
xlim([0 inf]); grid on
cdf_vals_RP_b = normcdf(val, mu, sigma);