%% Plot Clouds
x = [0.00317565500000000	0.00430400000000000	0.00249114900000000	0.0767309010000000	0.350846930000000	0.0882344960000000	0.000515437800000000	47.9000000000000	43	29.7917707500000	7.50236352600000	0.274458610000000	14.0877890200000	16.4625903900000	15.2474697800000	10.3678571500000	14.2160781250000	0.00244956000000000	0.00514753440000000	0.0100000000000000	0.00722766000000000	0.0288161260000000	0.309924890000000	0.00817096660000000	0.0826584950000000];
n_runs = 100;
%Start a parallel pool only if parallel tool box is available
parpool();
%Initialize the matrix to hold all data
All_simulation_data = [];
parfor i = 1:n_runs
    % Generate 100 simulations
    [simulation_data] = Driver(x);
    All_simulation_data = [All_simulation_data, simulation_data];
end
%Save in m file
save('Trial_run.mat')

delete(gcp);

%% Only run this part if you just want the plot
load('Trial_run.mat')

%Initialize matrices for each tissue
blood = [];
LLN = [];
MLN = [];
SLN = [];
spleenRP = [];
spleenWP = [];
spleen = [];
ROB = [];
%Create clouds matrices
for i = 0:n_runs-1
    blood = [blood, All_simulation_data(:,2+(9*i))];
    LLN = [LLN, All_simulation_data(:,3+(9*i))];
    MLN = [MLN, All_simulation_data(:,4+(9*i))];
    SLN = [SLN, All_simulation_data(:,5+(9*i))];
    spleenRP = [spleenRP, All_simulation_data(:,6+(9*i))];
    spleenWP = [spleenWP, All_simulation_data(:,7+(9*i))];
    spleen = [spleen, All_simulation_data(:,8+(9*i))];
    ROB = [ROB, All_simulation_data(:,9+(9*i))];
end

%Load scaled mouse data
load('AllMice.mat')

%Calculate total spleen cells (RP+WP)
Spleen1O = M1O(:,6) + M1O(:,7);
Spleen2O = M2O(:,6) + M2O(:,7);
Spleen3O = M3O(:,6) + M3O(:,7);
Spleen4O = M4O(:,6) + M4O(:,7);
Spleen1N = M1N(:,5) + M1N(:,6);
Spleen2N = M2N(:,5) + M2N(:,6);
Spleen3N = M3N(:,5) + M3N(:,6);
Spleen4N = M4N(:,5) + M4N(:,6);

time = All_simulation_data(:,1);
%% Colors and transparency settings
simFaceColor  = [114 147 203]./255;  % simulation face
simEdgeColor  = [0 0.4470 0.7410];  % simulation edge
alphaSimLegend = 0.4;  % more visible version for legend
expColor      = [0.6350 0.0780 0.1840];  % experimental color
alphaSim      = 0.04;
alphaExp      = 0.5;
%% FIGURE 1 blood & LNs
fig1 = figure(1);
ax = subplot(2,2,1);
set(gca, 'YScale', 'log')
ylim([0 1E+6])
xlabel('Time (h)')
ylabel('Cell count')
title('Bloodstream')
ax = gca;
ax.FontSize = 12;
set(gca, 'FontName', 'Times New Roman')
box on;
hold on

% Dummy sim point for legend
hSimLegend = scatter(NaN, NaN, 30, ...
'MarkerFaceColor', simFaceColor, ...
'MarkerEdgeColor', simEdgeColor, ...
'MarkerFaceAlpha', alphaSimLegend, ...
'MarkerEdgeAlpha', alphaSimLegend);

scatter(time, blood,8,'MarkerFaceColor',simFaceColor,'MarkerEdgeColor',simEdgeColor,...
'MarkerFaceAlpha',alphaSim,'MarkerEdgeAlpha',alphaSim)
% Plot simulation mean line
hAvg = plot(time, mean(blood, 2), 'Color', 'k', 'LineWidth', 1);
hExp = scatter(M1O(:,1),M1O(:,2),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp);
scatter(M1N(:,1),M1N(:,2),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2O(:,1),M2O(:,2),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3O(:,1),M3O(:,2),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4O(:,1),M4O(:,2),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2N(:,1),M2N(:,2),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3N(:,1),M3N(:,2),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4N(:,1),M4N(:,2),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
hold off
legend([hExp, hAvg, hSimLegend], {'Experimental', 'Sim Average', 'Sim'}, 'Location', 'best');
set(gca, 'FontName', 'Times New Roman')
ylim([10 1E+6])
annotation('textbox', ...
    [ax.Position(1)-0.1, ax.Position(2)+ax.Position(4)-0.02, 0.05, 0.05], ...
    'String', 'A', ...
    'LineStyle','none', ...
    'FontWeight','bold', ...
    'FontSize',12, ...
    'FontName','Times New Roman', ...
    'HorizontalAlignment','center', ...
    'VerticalAlignment','bottom');
ax = subplot(2,2,2);
scatter(time, LLN,8,'MarkerFaceColor',simFaceColor,'MarkerEdgeColor',simEdgeColor,...
'MarkerFaceAlpha',alphaSim,'MarkerEdgeAlpha',alphaSim)
set(gca, 'YScale', 'log')
ylim([10 1E+6])
xlabel ('Time (h)')
ylabel ('Cell count')
title('Large LNs')
ax = gca;
ax.FontSize = 12;
box on;
hold on
avLLN = mean(LLN,2);
plot(time,avLLN,'Color', 'k','LineWidth', 1)
scatter(M1O(:,1),M1O(:,3),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2O(:,1),M2O(:,3),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3O(:,1),M3O(:,3),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4O(:,1),M4O(:,3),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M1N(:,1),M1N(:,3),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2N(:,1),M2N(:,3),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3N(:,1),M3N(:,3),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4N(:,1),M4N(:,3),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
hold off
set(gca, 'FontName', 'Times New Roman')
annotation('textbox', ...
    [ax.Position(1)-0.1, ax.Position(2)+ax.Position(4)-0.02, 0.05, 0.05], ...
    'String', 'B', ...
    'LineStyle','none', ...
    'FontWeight','bold', ...
    'FontSize',12, ...
    'FontName','Times New Roman', ...
    'HorizontalAlignment','center', ...
    'VerticalAlignment','bottom');

ax = subplot(2,2,3);
scatter(time, MLN,8,'MarkerFaceColor',simFaceColor,'MarkerEdgeColor',simEdgeColor,...
'MarkerFaceAlpha',alphaSim,'MarkerEdgeAlpha',alphaSim)
set(gca, 'YScale', 'log')
ylim([10 1E+6])
xlabel ('Time (h)')
ylabel ('Cell count')
title('Medium LNs')
ax = gca;
ax.FontSize = 12;
box on;
hold on
avMLN = mean(MLN,2);
plot(time,avMLN,'Color', 'k','LineWidth', 1)
scatter(M1O(:,1),M1O(:,4),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2O(:,1),M2O(:,4),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3O(:,1),M3O(:,4),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4O(:,1),M4O(:,4),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M1N(:,1),M1N(:,4),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2N(:,1),M2N(:,4),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3N(:,1),M3N(:,4),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4N(:,1),M4N(:,4),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
hold off
set(gca, 'FontName', 'Times New Roman')
annotation('textbox', ...
    [ax.Position(1)-0.1, ax.Position(2)+ax.Position(4)-0.02, 0.05, 0.05], ...
    'String', 'C', ...
    'LineStyle','none', ...
    'FontWeight','bold', ...
    'FontSize',12, ...
    'FontName','Times New Roman', ...
    'HorizontalAlignment','center', ...
    'VerticalAlignment','bottom');

ax = subplot(2,2,4);
scatter(time, SLN,8,'MarkerFaceColor',simFaceColor,'MarkerEdgeColor',simEdgeColor,...
'MarkerFaceAlpha',alphaSim,'MarkerEdgeAlpha',alphaSim)
set(gca, 'YScale', 'log')
ylim([10 1E+6])
xlabel ('Time (h)')
ylabel ('Cell count')
title('Small LNs')
ax = gca;
ax.FontSize = 12;
box on;
hold on
avSLN = mean(SLN,2);
plot(time,avSLN,'Color', 'k','LineWidth', 1)
scatter(M1O(:,1),M1O(:,5),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2O(:,1),M2O(:,5),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3O(:,1),M3O(:,5),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4O(:,1),M4O(:,5),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
hold off
set(gca, 'FontName', 'Times New Roman')
annotation('textbox', ...
    [ax.Position(1)-0.1, ax.Position(2)+ax.Position(4)-0.02, 0.05, 0.05], ...
    'String', 'D', ...
    'LineStyle','none', ...
    'FontWeight','bold', ...
    'FontSize',12, ...
    'FontName','Times New Roman', ...
    'HorizontalAlignment','center', ...
    'VerticalAlignment','bottom');
% Save as high-resolution TIFF (600 dpi)
exportgraphics(fig1, 'Figure_2.tif', 'Resolution', 600)
%% Figure 2 Spleen
fig2 = figure(2);
ax = subplot(2,2,1);
scatter(time, spleenRP,8,'MarkerFaceColor',simFaceColor,'MarkerEdgeColor',simEdgeColor,...
'MarkerFaceAlpha',alphaSim,'MarkerEdgeAlpha',alphaSim)
set(gca, 'YScale', 'log')
ylim([10 1E+6])
xlabel ('Time (h)')
ylabel ('Cell count')
title('Spleen RP')
ax = gca;
ax.FontSize = 12;
box on;
hold on
avspleenRP = mean(spleenRP,2);
plot(time,avspleenRP,'Color', 'k','LineWidth', 1)
scatter(M1O(:,1),M1O(:,6),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2O(:,1),M2O(:,6),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3O(:,1),M3O(:,6),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4O(:,1),M4O(:,6),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M1N(:,1),M1N(:,5),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2N(:,1),M2N(:,5),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3N(:,1),M3N(:,5),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4N(:,1),M4N(:,5),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
hold off
set(gca, 'FontName', 'Times New Roman')
annotation('textbox', ...
    [ax.Position(1)-0.1, ax.Position(2)+ax.Position(4)-0.02, 0.05, 0.05], ...
    'String', 'A', ...
    'LineStyle','none', ...
    'FontWeight','bold', ...
    'FontSize',12, ...
    'FontName','Times New Roman', ...
    'HorizontalAlignment','center', ...
    'VerticalAlignment','bottom');
ax = subplot(2,2,2);
scatter(time, spleenWP,8,'MarkerFaceColor',simFaceColor,'MarkerEdgeColor',simEdgeColor,...
'MarkerFaceAlpha',alphaSim,'MarkerEdgeAlpha',alphaSim)
set(gca, 'YScale', 'log')
ylim([10 1E+6])
xlabel ('Time (h)')
ylabel ('Cell count')
title('Spleen WP')
ax = gca;
ax.FontSize = 12;
box on;
hold on
avspleenWP = mean(spleenWP,2);
plot(time,avspleenWP,'Color', 'k','LineWidth', 1)
scatter(M1O(:,1),M1O(:,7),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2O(:,1),M2O(:,7),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3O(:,1),M3O(:,7),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4O(:,1),M4O(:,7),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M1N(:,1),M1N(:,6),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2N(:,1),M2N(:,6),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3N(:,1),M3N(:,6),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4N(:,1),M4N(:,6),[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
hold off
set(gca, 'FontName', 'Times New Roman')
annotation('textbox', ...
    [ax.Position(1)-0.1, ax.Position(2)+ax.Position(4)-0.02, 0.05, 0.05], ...
    'String', 'B', ...
    'LineStyle','none', ...
    'FontWeight','bold', ...
    'FontSize',12, ...
    'FontName','Times New Roman', ...
    'HorizontalAlignment','center', ...
    'VerticalAlignment','bottom');
ax = subplot(2,2,[3,4]);
scatter(time, spleen,8,'MarkerFaceColor',simFaceColor,'MarkerEdgeColor',simEdgeColor,...
'MarkerFaceAlpha',alphaSim,'MarkerEdgeAlpha',alphaSim)
set(gca, 'YScale', 'log')
ylim([10 1E+6])
xlabel ('Time (h)')
ylabel ('Cell count')
title('Spleen')
ax = gca;
ax.FontSize = 12;
box on;
hold on
avspleen = mean(spleen,2);
plot(time,avspleen,'Color', 'k','LineWidth', 1)
scatter(M1O(:,1),Spleen1O,[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2O(:,1),Spleen2O,[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3O(:,1),Spleen3O,[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4O(:,1),Spleen4O,[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M1N(:,1),Spleen1N,[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M2N(:,1),Spleen2N,[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M3N(:,1),Spleen3N,[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)
scatter(M4N(:,1),Spleen4N,[],'filled','MarkerFaceColor',expColor,'MarkerFaceAlpha',alphaExp)

hold off
set(gca, 'FontName', 'Times New Roman')
annotation('textbox', ...
    [ax.Position(1)-0.1, ax.Position(2)+ax.Position(4)-0.02, 0.05, 0.05], ...
    'String', 'C', ...
    'LineStyle','none', ...
    'FontWeight','bold', ...
    'FontSize',12, ...
    'FontName','Times New Roman', ...
    'HorizontalAlignment','center', ...
    'VerticalAlignment','bottom');
exportgraphics(fig2, 'Figure_3.tif', 'Resolution', 600)
%% Figure 3 ROB
fig3 = figure(3);
scatter(time, ROB,8,'MarkerFaceColor',simFaceColor,'MarkerEdgeColor',simEdgeColor,...
'MarkerFaceAlpha',alphaSim,'MarkerEdgeAlpha',alphaSim)
set(gca, 'YScale', 'log')
ylim([10 1E+6])
xlabel ('Time (h)')
ylabel ('Cell count')
title('Rest of body')
ax = gca;
ax.FontSize = 12;
box on;
hold on
avROB = mean(ROB,2);
plot(time,avROB,'Color', 'k','LineWidth', 1)
hold off
set(gca, 'FontName', 'Times New Roman')
exportgraphics(fig3, 'Figure_4.tif', 'Resolution', 600)