function [AllCells] = CellTransferL(v,AllCells,rt,sd)
% Find cells currently in node `v`
nTrials = find(AllCells(3,:)==v);
new = find(AllCells(1,nTrials)==0);
% Assign residence time to each new cell in the node from a normal distribution
if (~isempty(new))
        rtCellNew = normrnd(rt,sd,[1,size(new,2)]);
        rtCellNew = max(rtCellNew, rt - 3 * sd); %truncate at 3 standards deviations
        rtCellNew = min(rtCellNew, rt + 3 * sd);
        AllCells(2,nTrials(new)) = rtCellNew;
end

% Update AllCells
% cells leaving to the blood (node = 1) and will have age = 0 and rt = 0
if (~isempty(nTrials))
    ToLeave = find(AllCells(1,nTrials) >= AllCells(2,nTrials));
    AllCells(3,nTrials(ToLeave)) = 1;
    AllCells(1,nTrials(ToLeave)) = 0;
    AllCells(2,nTrials(ToLeave)) = 0;
end

end