function [AllCells] = CellTransferB(v, AllCells, MovingParams)
% Find cells currently in node v
nTrials = find(AllCells(3,:) == v);
NCells = numel(nTrials);
% Get movement distributions
means = MovingParams(2:6);
stdevs = MovingParams(9:13);
randVec = max(0, stdevs .* randn(1,5) + means);
Nmoved = round(NCells * randVec);

% Cap and evenly distribute excess movement
totalToMove = sum(Nmoved);
if totalToMove > NCells
    Nmoved = floor(Nmoved * NCells / totalToMove);
    diff = NCells - sum(Nmoved);
    if diff > 0
        startIdx = randi(5);
        for i = 1:diff
            group = mod(startIdx + i - 2, 5) + 1;
            Nmoved(group) = Nmoved(group) + 1;
        end
    end
end

% Default node no.: 1 (no movement)
stuff = ones(1, NCells);

% Allocate if there's any movement
if sum(Nmoved) > 0
    randPool = randperm(NCells, sum(Nmoved));
    splitIdx = [0, cumsum(Nmoved)];
    vectors = arrayfun(@(i) randPool(splitIdx(i)+1 : splitIdx(i+1)), 1:5, 'UniformOutput', false);

    % Resolve duplicates by retaining in one original group
    all_ids = [vectors{:}];
    [uniq_ids, ~, ic] = unique(all_ids);
    dup_counts = accumarray(ic(:), 1);
    dup_ids = uniq_ids(dup_counts > 1);

    for i = 1:numel(dup_ids)
        dup = dup_ids(i);
        containing_groups = find(cellfun(@(v) any(v == dup), vectors));
        keep = containing_groups(randi(numel(containing_groups)));
        for j = containing_groups
            if j ~= keep
                vectors{j}(vectors{j} == dup) = [];
            end
        end
    end

    % Assign new nodes based on group
    for k = 1:5
        stuff(vectors{k}) = k + 1;
    end
end

% Update AllCells
% cells leaving will have age = 0 and rt = 0

AllCells(3, nTrials) = stuff;
moved = stuff ~= v;
AllCells(1, nTrials(moved)) = 0;
AllCells(2, nTrials(moved)) = 0;
end