classdef Body < handle
    properties (Access = public)
        %Define properties to be used within the class
        stoptime
        steptime
        NA0
        sd
        rt
        MovingParams
        AllCells
        CellCount
        i
        SSE
        ToDie
        Pdead    
    end
    methods
        function obj = Body(stoptime, steptime, NA0, sd, rt, MovingParams, Pdead)
            %% Assign the propatry value to the class object (NaiveBody)
            obj.stoptime = stoptime;
            obj.steptime = steptime;
            obj.NA0 = NA0;
            obj.sd = sd;
            obj.rt = rt;
            obj.MovingParams = MovingParams;
            obj.i = 1;
            obj.SSE = [];
            obj.ToDie = [];
            obj.Pdead = Pdead;
            % Penalize the system with a really big number if the sum of
            % the average moving parameters are >= 1 for the bloodstream
            % and the spleenRP
            if sum(obj.MovingParams(2:5)) > 1 || sum(obj.MovingParams(6:7))>1
                BigNumber = 10E15;
                obj.SSE = BigNumber;
            else
                % Initialize the matrix where cells data is stored
                obj.AllCells = [zeros(1,NA0(1)); zeros(1, NA0(1)); ones(1, NA0(1))];
                % Create nodes as objects using class "Tissue" 
                blood = Tissue(obj.NA0(1),MovingParams,obj.rt,obj.sd);
                LLN = Tissue(obj.NA0(2),obj.MovingParams,obj.rt,obj.sd);
                MLN = Tissue(obj.NA0(3),obj.MovingParams,obj.rt,obj.sd);
                SLN = Tissue(obj.NA0(4),obj.MovingParams,obj.rt,obj.sd);
                spleenRP = Tissue(obj.NA0(5),obj.MovingParams,obj.rt,obj.sd);
                spleenWP = Tissue(obj.NA0(6),obj.MovingParams,obj.rt,obj.sd);
                ROB = Tissue(obj.NA0(7),obj.MovingParams,obj.rt,obj.sd);
                % Start recording run time
                tic
                %% Start cell recirculation
                for t = 0:steptime: stoptime
                   % RunTimeStep functions move cells between nodes
                   [blood,obj.AllCells] = blood.RunTimeStepB (1,obj.AllCells);
                   [LLN,obj.AllCells] = LLN.RunTimeStepL (2,2,obj.AllCells);
                   [MLN,obj.AllCells] = MLN.RunTimeStepL (3,3,obj.AllCells);
                   [SLN,obj.AllCells] = SLN.RunTimeStepL (4,4,obj.AllCells);
                   [spleenRP,obj.AllCells] = spleenRP.RunTimeStepRP (5,7,obj.AllCells);
                   [spleenWP,obj.AllCells] = spleenWP.RunTimeStepWP (7,5,obj.AllCells);
                   [ROB,obj.AllCells] = ROB.RunTimeStepL (6,6,obj.AllCells);

                   %% Count cells in each node
                   bloodCells = size(find(obj.AllCells(3,:)==1),2);
                   LLNCells = size(find(obj.AllCells(3,:)==2),2);
                   MLNCells = size(find(obj.AllCells(3,:)==3),2);
                   SLNCells = size(find(obj.AllCells(3,:)==4),2);
                   SpleenRPCells = size(find(obj.AllCells(3,:)==5),2);
                   SpleenWPCells = size(find(obj.AllCells(3,:)==7),2);
                   SpleenTot = SpleenRPCells + SpleenWPCells;
                   ROBCells = size(find(obj.AllCells(3,:)==6),2);
                   % Record cell counts in the CellCount matrix
                   if obj.i==1
                        obj.CellCount(obj.i,:) = [t, NA0(1), zeros(1,7)];
                   else
                        obj.CellCount(obj.i,:) = [t, bloodCells, ...
                        LLNCells, MLNCells, SLNCells, SpleenRPCells,...
                        SpleenWPCells, SpleenTot, ROBCells];
                   end
                   obj.AllCells(1,:) = obj.AllCells(1,:)+steptime;
                   obj.i = obj.i+1;
                   %% Death function
                   HowMany = round(size(obj.AllCells,2)*obj.Pdead);
                   Die = randi([1, size(obj.AllCells,2)], 1, HowMany); % randomly pick which cells to die
                   obj.AllCells(:,Die) = [];
                end
                tt = toc;
                % Print out run time
                fprintf('Completed in %1.2f seconds.\n', tt);
                %% Plot the outputs
                % plotting(obj.CellCount(:,1),obj.CellCount(:,2),...
                % obj.CellCount(:,3),obj.CellCount(:,4),...
                % obj.CellCount(:,5),obj.CellCount(:,6),...
                % obj.CellCount(:,7), obj.CellCount(:,8),...
                % obj.CellCount(:,9),...
                % ["Bloodstream", "Large LNs", "Medium LNs", "Small LNs", "RP", "WP", "Spleen", "Rest of body"]);
            
                %% Error calculations
                % Load experimental data
                load('ScaledLossData.mat')
                Average;
                DS1; % Data set 1
                DS2; % Data set 2
                MIN; %Lowest values in each node at the different time points
                MAX; %Highest values in each node at the different time points

                k = size(Average,1); %no. rows
                m = size(Average,2); %no. columns

                % Initializing time, cell count, and error matrices
                timeSim = zeros(1,k);
                NASim = zeros(k,m-1);
                Error = zeros(size(Average,1),6);

                for i = 1:k
                        timeSim(i) = find(obj.CellCount(:,1) <= Average(i,1),1, 'last');
                        NASim(i,:) = obj.CellCount(timeSim(i),2:7);
                end
                % SSE
                Error = abs(NASim-Average(:,2:end)).^2;
                obj.SSE = sum(sum(Error));
                
                % Penalize the Error if it exceeds 30% of the highest or
                % lowest data point
                upper_bound = MAX*1.3;
                lower_bound = MIN*0.7;
                A = NASim>= lower_bound;
                B = NASim<= upper_bound;
                within_bound = [A B];
                K = sum(any(~within_bound));
                if K>0
                    obj.SSE = obj.SSE*2*K;
                end
            end
        end
    end
end