%% Simulate 100 simulations for a benchmark, fty720 at 0.1mg, fty720 at 1mg
parpool();

FTY = [0 0 0]; %No drug
All_simulation_data = [];
parfor i = 1:100
     [simulation_data] = Driver(FTY);
     All_simulation_data = [All_simulation_data, simulation_data];
end

blood = [];
parfor i = 0:99
    blood = [blood, All_simulation_data(:,2+(9*i))];
end
baseblood = mean(blood,2);
save("blood_fty720_benchmark.mat");

FTY = [0.1 99.98  0.00020855]; %0.1mg oral dose
All_simulation_data = [];
parfor i = 1:100
     [simulation_data] = Driver(FTY);
     All_simulation_data = [All_simulation_data, simulation_data];
end
blood = [];
parfor i = 0:99
    blood = [blood, All_simulation_data(:,2+(9*i))];
end
sim_small = blood;
save("blood_fty720_0.1.mat");

FTY = [1 99.98  0.000208855]; %1mg oral dose

All_simulation_data = [];

parfor i = 1:100
     [simulation_data] = Driver(FTY);
     All_simulation_data = [All_simulation_data, simulation_data];
end
blood = [];
parfor i = 0:99
    blood = [blood, All_simulation_data(:,2+(9*i))];
end
sim_large = blood;

delete(gcp);
save("blood_fty720_1.mat");