%% Plot FTY720 cloud
%% Simulate 100 simulations for a benchmark, fty720 at 0.1mg, fty720 at 1mg

load("blood_fty720_benchmark.mat");
baseblood = mean(blood,2);

load("blood_fty720_0.1.mat");
sim_small = blood;

load("blood_fty720_1.mat");
sim_large = blood;

sim_small_perc = (sim_small./baseblood)*100;
sim_large_perc = (sim_large./baseblood)*100;

t = All_simulation_data(:,1);

Data_small = [100, 20, 15, 75, 90]; %0.1 rats
Data_large = [100, 5, 2, 7, 80]; %1 rats

% Adjust the time to start after system stabilizes
t_new = All_simulation_data(301:end,1)-30;

mean_small = mean(sim_small_perc,2);
mean_large = mean(sim_large_perc,2);

figure(1)
set(gca, 'FontName', 'Times New Roman', 'Box', 'on')
plot(t_new, mean_small(301:end), "LineWidth", 2)
xticks([0, 12, 24, 72, 168])
ax = gca;
ax.FontSize = 12;
hold on
scatter([0, 12, 24, 72, 168], Data_small, 100, "black", 'filled','d')
plot(t_new, mean_large(301:end), "LineWidth", 2)
scatter([0, 12, 24, 72, 168], Data_large, 100, "black", 'filled','o')

xticklabels({'0h', '12h', '1d', '3d', '7d'});
ylabel('T cells % of control')
xlabel('Time post treatment')
legend('0.1 mg/kg', 'Exp 0.1 mg/kg', '1 mg/kg','Exp 1 mg/kg', 'Location', 'northeastoutside')
set(gca, 'FontName', 'Times New Roman', 'Box', 'on')
hold off

figure(2)
ax = subplot(2,1,1);

% Plot content first...
scatter(t_new, sim_small_perc(301:end,:), 8, ...
    'MarkerFaceColor',[0 0.4470 0.7410], ...
    'MarkerEdgeColor',[0 0.4470 0.7410], ...
    'MarkerFaceAlpha',0.04, 'MarkerEdgeAlpha',0.04, ...
    'HandleVisibility','off');
hold on
h1 = scatter(nan, nan, 8, 'MarkerFaceColor',[0 0.4470 0.7410], ...
    'MarkerEdgeColor',[0 0.4470 0.7410], 'MarkerFaceAlpha',1, 'MarkerEdgeAlpha',1);
h2 = plot(t_new, mean_small(301:end), "LineWidth", 1, 'Color', 'k');
h3 = scatter([0, 12, 24, 72, 168], Data_small, 100, 'd', 'MarkerFaceColor',[0.6350 0.0780 0.1840], ...
    'MarkerEdgeColor',[0.6350 0.0780 0.1840], 'MarkerFaceAlpha',1);

% Axes formatting
ylim([0 100])
xticks([0, 12, 24, 72, 168])
xticklabels({'0h', '12h', '1d', '3d', '7d'})
ylabel('T cells % of control')
legend([h3, h2, h1], {'Exp 0.1 mg/kg', '0.1 mg/kg average sim', '0.1 mg/kg sim'}, 'Location', 'northeastoutside')
set(gca, 'FontName', 'Times New Roman', 'Box', 'on', 'FontSize', 12)
hold off
annotation('textbox', ...
    [ax.Position(1)-0.1, ax.Position(2)+ax.Position(4)-0.02, 0.05, 0.05], ...
    'String', 'A', ...
    'LineStyle','none', ...
    'FontWeight','bold', ...
    'FontSize',12, ...
    'FontName','Times New Roman', ...
    'HorizontalAlignment','center', ...
    'VerticalAlignment','bottom');

ax = subplot(2,1,2);

scatter(t_new, sim_large_perc(301:end,:), 8, ...
    'MarkerFaceColor',[0 0.4470 0.7410], ...
    'MarkerEdgeColor',[0 0.4470 0.7410], ...
    'MarkerFaceAlpha',0.04, 'MarkerEdgeAlpha',0.04, ...
    'HandleVisibility','off');
hold on
h1 = scatter(nan, nan, 8, 'MarkerFaceColor',[0 0.4470 0.7410], ...
    'MarkerEdgeColor',[0 0.4470 0.7410], 'MarkerFaceAlpha',1, 'MarkerEdgeAlpha',1);
h2 = plot(t_new, mean_large(301:end), "LineWidth", 1, 'Color', 'k');
h3 = scatter([0, 12, 24, 72, 168], Data_large, 100, 'o', 'MarkerFaceColor',[0.6350 0.0780 0.1840], ...
    'MarkerEdgeColor',[0.6350 0.0780 0.1840], 'MarkerFaceAlpha',1);

ylim([0 100])
xticks([0, 12, 24, 72, 168])
xticklabels({'0h', '12h', '1d', '3d', '7d'})
xlabel('Time post treatment (days)')
ylabel('T cells % of control')
legend([h3, h2, h1], {'Exp 1 mg/kg', '1 mg/kg average sim', '1 mg/kg sim'}, 'Location', 'northeastoutside')
set(gca, 'FontName', 'Times New Roman', 'Box', 'on', 'FontSize', 12)
hold off
annotation('textbox', ...
    [ax.Position(1)-0.1, ax.Position(2)+ax.Position(4)-0.02, 0.05, 0.05], ...
    'String', 'B', ...
    'LineStyle','none', ...
    'FontWeight','bold', ...
    'FontSize',12, ...
    'FontName','Times New Roman', ...
    'HorizontalAlignment','center', ...
    'VerticalAlignment','bottom');
exportgraphics(gcf, 'Figure_5.png', 'Resolution', 600)