classdef Tissue < handle
    properties (Access = public)
        NA0
        MovingParams
        rt
        sd
    end
    methods
        function obj = Tissue(NA0,MovingParams,rt,sd)
            obj.NA0 = NA0;
            obj.MovingParams = MovingParams;
            obj.rt = rt;
            obj.sd = sd;
        end
        
        %% Bloodstream dynamics
        function [obj,AllCells] = RunTimeStepB(obj,v,AllCells) % v = node number
            [AllCells] = CellTransferB(v,AllCells, obj.MovingParams);
        end
        %% RP dynamics
        function [obj,AllCells] = RunTimeStepRP(obj,v,p,AllCells) % v,p = RP, WP
            [AllCells] = CellTransferRP(v,p,AllCells, obj.MovingParams);
        end
        %% LNs dynamics
        function [obj,AllCells,drug_concentration] = RunTimeStepL(obj,v,w,AllCells,drug_concentration) % v = node number, w = rt & sd index
            [AllCells,drug_concentration] = CellTransferL(v,AllCells,obj.rt(w),obj.sd(w),drug_concentration);
        end
        %% WP dynamics
        function [obj,AllCells,drug_concentration] = RunTimeStepWP(obj,v,w,AllCells,drug_concentration) %v = node number, w = rt & sd index
            [AllCells,drug_concentration] = CellTransferWP(v,AllCells,obj.rt(w),obj.sd(w),drug_concentration);
        end

    end

end