function [simulation_data] = Driver(FTY)
% FTY = [0.1 99.98  0.00020855]; %FTY720 parameters
x = [0.00317565500000000	0.00430400000000000	0.00249114900000000	0.0767309010000000	0.350846930000000	0.0882344960000000	0.000515437800000000	47.9000000000000	43	29.7917707500000	7.50236352600000	0.274458610000000	14.0877890200000	16.4625903900000	15.2474697800000	10.3678571500000	14.2160781250000	0.00244956000000000	0.00514753440000000	0.0100000000000000	0.00722766000000000	0.0288161260000000	0.309924890000000	0.00817096660000000	0.0826584950000000 FTY];
%% Node no.
% 1. Blood
% 2. LLN
% 3. MLN
% 4. SLN
% 5. spleenRP
% 6. ROB
% 7. spleenWP
% 8. spleen total

% MovingParams:
% 1. blank
% 2. b->LLN
% 3. b->MLN
% 4. b->SLN
% 5. b->spleenRP
% 6. b->ROB
% 7. RP->spleenWP
% 8. RP-> blood

% Residence time meu&sigma:
% 1. blank
% 2. LLN
% 3. MLN
% 4. SLN
% 5. spleenWP
% 6. ROB
% 7. blank
% 8. blank

%% Define system parameters
MovingParams = [0 x(1) x(2) x(3) x(4) x(5) x(6) x(7) x(19) x(20) x(21) x(22) x(23) x(24) x(25)];
rt = [0, x(8), x(9), x(10), x(11), x(12), 0, 0];
sd = [0, x(13), x(14), x(15), x(16), x(17), 0, 0];
Pdead = x(18);

stoptime = 30+(24*7);
steptime = 0.1;
NA0 = [5000 0 0 0 0 0 0];

%FTY720 parameters
max_dose = x(26);
Emax = x(27);
EC50 = x(28);

FTY_Body = Body(stoptime,steptime,NA0,sd,rt,MovingParams,Pdead,max_dose,Emax,EC50);
simulation_data = [FTY_Body.CellCount];
end