function [AllCells] = CellTransferRP(v,p,AllCells, MovingParams)
% Find cells currently in node v
nTrials = find(AllCells(3,:)==v);
NCells = numel(nTrials);
% Get movement distributions
means = MovingParams(7:8);
stdevs = MovingParams(14:15);
randVec = max(0, stdevs .* randn(1,2) + means);
Nmoved = round(NCells * randVec);

% Default node no.: 5 (no movement)
stuff = v * ones(1, NCells);
totalToMove = sum(Nmoved);
if totalToMove > NCells
    Nmoved = floor(Nmoved * NCells / totalToMove);
    diff = NCells - sum(Nmoved);
    if diff > 0
        startIdx = randi(2);
        for i = 1:diff
            group = mod(startIdx + i - 2, 2) + 1;
            Nmoved(group) = Nmoved(group) + 1;
        end
    end
end

% Allocate if there's any movement
if sum(Nmoved) > 0
    % Select random pool of cells to move
    randPool = randperm(NCells, sum(Nmoved));

    % Split into 2 groups based on Nmoved counts
    splitIdx = [0, cumsum(Nmoved)];
    vectors = arrayfun(@(i) randPool(splitIdx(i)+1 : splitIdx(i+1)), 1:2, 'UniformOutput', false);

    % Resolve duplicates (cells assigned to multiple groups)
    all_ids = [vectors{:}];
    [uniq_ids, ~, ic] = unique(all_ids);
    dup_counts = accumarray(ic(:), 1);
    dup_ids = uniq_ids(dup_counts > 1);

    for i = 1:numel(dup_ids)
        dup = dup_ids(i);
        containing_groups = find(cellfun(@(v) any(v == dup), vectors));
        % randomly keep in one group
        keep = containing_groups(randi(numel(containing_groups))); 
        for j = containing_groups
            if j ~= keep
                vectors{j}(vectors{j} == dup) = []; % remove from others
            end
        end
    end

    stuff(vectors{1}) = p;   % Assign first group to p = WP
    stuff(vectors{2}) = 1;   % Assign second group to 1 = blood
end

% Update AllCells
% cells leaving will have age = 0 and rt = 0
AllCells(3, nTrials) = stuff;
moved = stuff ~= 5;
AllCells(1, nTrials(moved)) = 0;
AllCells(2, nTrials(moved)) = 0;
end