function [AllCells, drug_concentration] = CellTransferL(v,AllCells,rt,sd,drug_concentration)

nTrials = find(AllCells(3,:)==v);
new = find(AllCells(1,nTrials)==0);

    if (~isempty(new))
        rtCellNew = normrnd(rt,sd,[1,size(new,2)]);
        rtCellNew = max(rtCellNew, rt - 3 * sd);
        rtCellNew = min(rtCellNew, rt + 3 * sd);
        AllCells(2,nTrials(new)) = rtCellNew;
    end

    if (~isempty(nTrials))
        ToLeave = find(AllCells(1,nTrials) >= AllCells(2,nTrials));
        if drug_concentration == 0 || isnan(drug_concentration)
            HowMany = round(numel(ToLeave));
        else
            HowMany = round(numel(ToLeave)- (round(drug_concentration/100*numel(ToLeave))));
        end
        if isnan(HowMany)
            Actually = [];
        else
            Actually = ToLeave(1:HowMany);
        end
        AllCells(3,nTrials(Actually)) = 1;
        AllCells(1,nTrials(Actually)) = 0;
        AllCells(2,nTrials(Actually)) = 0;
    end

end