classdef Body < handle
    properties (Access = public)
        stoptime
        steptime
        NA0
        sd
        rt
        MovingParams
        AllCells
        CellCount
        i
        SSE
        ToDie
        Pdead
        drug_concentration
      
    end
    methods
        function obj = Body(stoptime, steptime, NA0, sd, rt, MovingParams, Pdead, max_dose, Emax, EC50)
            
            %% Parameters
            %NA0 initial cell count
            %steptime 6 minute step times
            %stoptime 7 days
            obj.stoptime = stoptime;
            obj.steptime = steptime;
            obj.NA0 = NA0;
            obj.sd = sd;
            obj.rt = rt;
            obj.MovingParams = MovingParams;
            obj.i = 1;
            obj.SSE = [];
            obj.ToDie = [];
            obj.Pdead = Pdead;
            % Penalize the system with a really big number if the sum of
            % the average moving parameters are >= 1 for the bloodstream
            % and the spleenRP
            if sum(obj.MovingParams(2:5)) > 0.999 || sum(obj.MovingParams(6:7))>1
                BigNumber = 10E15;
                obj.SSE = BigNumber;
            else

                obj.AllCells = [zeros(1,NA0(1)); zeros(1, NA0(1)); ones(1, NA0(1))];
                t = 0:steptime: stoptime;                
                % Parameters
                half_life = 23.4;              % Half-life of the drug (h)
                max_concentration = 100;    % Maximum concentration (target level)
                rise_time = 40;             % Time over which the drug concentration rises, 40
                % Decay constant based on half-life
                decay_constant = log(2) / half_life;
                drug_concentration_amnt = zeros(size(t,2),1);
                obj.drug_concentration = zeros(size(t,2),1);
                t_cr = 0; %Define critical time when thedrug concentration reaches the maximum amount

                blood = Tissue(obj.NA0(1),MovingParams,obj.rt,obj.sd);
                LLN = Tissue(obj.NA0(2),obj.MovingParams,obj.rt,obj.sd);
                MLN = Tissue(obj.NA0(3),obj.MovingParams,obj.rt,obj.sd);
                SLN = Tissue(obj.NA0(4),obj.MovingParams,obj.rt,obj.sd);
                spleenRP = Tissue(obj.NA0(5),obj.MovingParams,obj.rt,obj.sd);
                spleenWP = Tissue(obj.NA0(6),obj.MovingParams,obj.rt,obj.sd);
                ROB = Tissue(obj.NA0(7),obj.MovingParams,obj.rt,obj.sd);
                tic
                for t = 0:steptime: stoptime
                    % Simulate drug concentration
                    if t> 30
                        drug_concentration_amnt(obj.i) = (max_dose*((t-30)/(rise_time-30)));
                        obj.drug_concentration(obj.i) = (max_concentration*((t-30)/(rise_time-30)));
                        if drug_concentration_amnt(obj.i)== max_dose
                            t_cr = t;
                        end
                
                        if t>rise_time
                        drug_concentration_amnt(obj.i) = drug_concentration_amnt(obj.i-1) * exp(-decay_constant*steptime);
                        end
                
                        if t_cr>0
                                obj.drug_concentration(obj.i) = Emax * (drug_concentration_amnt(obj.i)) ./ (EC50 + drug_concentration_amnt(obj.i));
                        end
                    end
                   [blood,obj.AllCells] = blood.RunTimeStepB (1,obj.AllCells);
                   [LLN,obj.AllCells,obj.drug_concentration(obj.i)] = ...
                   LLN.RunTimeStepL (2,2,obj.AllCells,obj.drug_concentration(obj.i));
                   [MLN,obj.AllCells,obj.drug_concentration(obj.i)] = ...
                   MLN.RunTimeStepL (3,3,obj.AllCells,obj.drug_concentration(obj.i));
                   [SLN,obj.AllCells,obj.drug_concentration(obj.i)] = ...
                   SLN.RunTimeStepL (4,4,obj.AllCells,obj.drug_concentration(obj.i));
                   [spleenRP,obj.AllCells] = spleenRP.RunTimeStepRP (5,7,obj.AllCells);
                   [spleenWP,obj.AllCells,obj.drug_concentration(obj.i)] = ...
                   spleenWP.RunTimeStepWP (7,5,obj.AllCells,obj.drug_concentration(obj.i));
                   [ROB,obj.AllCells,obj.drug_concentration(obj.i)] = ...
                   ROB.RunTimeStepL (6,6,obj.AllCells,obj.drug_concentration(obj.i));
                                          
                   bloodCells = size(find(obj.AllCells(3,:)==1),2);
                   LLNCells = size(find(obj.AllCells(3,:)==2),2);
                   MLNCells = size(find(obj.AllCells(3,:)==3),2);
                   SLNCells = size(find(obj.AllCells(3,:)==4),2);
                   SpleenRPCells = size(find(obj.AllCells(3,:)==5),2);
                   SpleenWPCells = size(find(obj.AllCells(3,:)==7),2);
                   ROBCells = size(find(obj.AllCells(3,:)==6),2);
                   SpleenTot = SpleenRPCells + SpleenWPCells;
                   
                   if obj.i==1
                        obj.CellCount(obj.i,:) = [t, NA0(1), zeros(1,7)];
                   else
                        obj.CellCount(obj.i,:) = [t, bloodCells, ...
                        LLNCells, MLNCells, SLNCells, SpleenRPCells,...
                        SpleenWPCells, SpleenTot, ROBCells];
                   end
                   obj.AllCells(1,:) = obj.AllCells(1,:)+steptime;
                   obj.i = obj.i+1;
                end
                tt = toc;
                fprintf('Completed in %1.2f seconds.\n', tt);
            end
        end
    end
end