#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Cost function for timber production
# Description: Forest owners are paid the market price at the location where the forest is
#################################################################################################################################################################################################################################################

import pandas as pd
import pyomo.environ as pyo

def implement_timber_production_cost_function(model, data):
    """
    :param model: Pyomo model
    :param data: The dataset dict containing node and edge data
    :return: Cost function
    """

    model.nodes_timber_production_cost_constraint_01 = pyo.Constraint(model.timber_resources_indices_01, rule=lambda model, site: cost_function_pyomo(model, site, data))


def cost_function_pyomo(model, site, data):

    metadata = data['metadata']
    nodes_data_timber_production_sites_01 = data['node_data_timber_resources_01']

    timber_price = nodes_data_timber_production_sites_01.loc[site, 'Timber price [NOK/m3]'] / metadata['Timber density [kg/m3]'] # [NOK/kg]
    expansion_size = model.nodes_biomass_production_site_expansion_size_01[site]*1000*1000 # Timber production amount [kg timber per year]
    production_cost = timber_price * expansion_size / 1000 # [tNOK2024/a]

    return model.nodes_biomass_production_site_cost_01[site] == production_cost