#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Demand constraint
#################################################################################################################################################################################################################################################

import pyomo.environ as pyo

def implement_demand_constraint(model, hydrogen_demand, data):
    """
    Function to implement all the necessary constraints for the given nodes
    :param model: The pyomo model
    :param hydrogen_demand: The final hydrogen demand at the import side [kt hydrogen per year]
    :return: None
    """

    # Constraint: Sum of expansion sizes of all import terminals == final hydrogen demand
    model.demand_constraint = pyo.Constraint(rule=lambda model: demand_rule(model, hydrogen_demand))


def demand_rule(model, hydrogen_demand):
    ch2_imported = sum(model.nodes_ch2_shipping_terminal_expansion_size_07[ch2_shipping_terminal] for ch2_shipping_terminal in model.cH2_shipping_terminal_indices_07)
    ch2_produced = sum(model.nodes_biomass_gasification_hub_expansion_size_07[gasification_hub] for gasification_hub in model.wc_shipping_terminal_indices_07)

    return ch2_produced + ch2_imported == hydrogen_demand