#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Set up the framework for supply chain optimization
#################################################################################################################################################################################################################################################

import time
import pandas as pd
import geopandas as gpd
from optimizer import run_optimization
from analysis import perform_analysis
from functions.sensitivity_analysis import (perform_sensitivity_of_specific_costs_on_hydrogen_demand, perform_sensitivity_of_shipping_terminal_utilization_on_h2_demand,
                                            compare_sc_branches_cost_emissions, compare_sc_branches_shipping_costs, perform_pareto_sensitivity_bar)
from functions.initialize_metadata import initialize_metadata
import copy
from pathlib import Path

if __name__ == '__main__':

    # Directories
    data_dir = 'data/'
    pdir = str(Path.cwd().parent) + '\\'
    RUN_ID = 'BC'
    start_time = time.time()
    plot_nodes = True # Whether to generate a plot for the entire graph

    # METADATA
    metadata = pd.read_excel(data_dir + '/general/metadata.xlsx', index_col=0)['Value']

    # Read data
    print('### READING DATA ###')

    data = {}
    data['metadata'] = metadata
    data['emission_factors'] = pd.read_excel(data_dir + 'general/emission_factors.xlsx', index_col=0)['Value']

    data['node_data_timber_resources_01'] = gpd.read_feather(data_dir + 'node_data_01_biomass_' + RUN_ID + '.feather')  # Index = Biomass nodes, Columns = Potential [1000m3], Production costs [NOK/t]

    data['edge_data_timber_trucking_distance_02'] = pd.read_feather(data_dir + 'edge_data_02_transport_timber_from_forest_to_gasification_hub_' + RUN_ID + '_distance.feather')  # Indices = Biomass Nodes, Columns = Gasification Hubs, Values = Distance [m]
    data['edge_data_timber_trucking_driving_time_02'] = pd.read_feather(data_dir + 'edge_data_02_transport_timber_from_forest_to_gasification_hub_' + RUN_ID + '_driving_time.feather')  # Indices = Biomass Nodes, Columns = Gasification Hubs, Values = Driving time [sec]

    data['node_data_gasification_hubs_03'] = gpd.read_feather(data_dir + 'node_data_03_biomass_gasification.feather')  # Index = Gasification Hubs, Columns = size constraints (min/max), cost data

    data['edge_data_cH2_trucking_distance_04'] = pd.read_feather(data_dir + 'edge_data_04_transport_cH2_from_biomass_gasifier_to_cH2_shipping_terminal_0_distance.feather')  # Indices = Gasification Hubs, Columns = cH2 shipping terminals, Values = Distance [m]
    data['edge_data_cH2_trucking_driving_time_04'] = pd.read_feather(data_dir + 'edge_data_04_transport_cH2_from_biomass_gasifier_to_cH2_shipping_terminal_0_driving_time.feather')  # Indices = Gasification Hubs, Columns = cH2 shipping terminals, Values = Driving time [sec]
    data['edge_data_timber_trucking_distance_04'] = pd.read_feather(data_dir + 'edge_data_04_transport_timber_from_forest_to_wc_shipping_terminal_' + RUN_ID + '_distance.feather')  # Indices = Biomass Nodes, Columns = Wood chip shipping terminals, Values = Distance [m]
    data['edge_data_timber_trucking_driving_time_04'] = pd.read_feather(data_dir + 'edge_data_04_transport_timber_from_forest_to_wc_shipping_terminal_' + RUN_ID + '_driving_time.feather')  # Indices = Biomass Nodes, Columns = Wood chip shipping terminals, Values = Driving time [sec]

    data['node_data_cH2_shipping_terminals_05'] = gpd.read_feather(data_dir + 'node_data_05_cH2_shipping_terminals_export.feather')  # Index = cH2 shipping terminal places (export)
    data['node_data_wood_chip_shipping_terminals_05'] = gpd.read_feather(data_dir + 'node_data_05_wc_shipping_terminals_export.feather')  # Index = Wood chip shipping terminal places (export)

    data['edge_data_shipping_distance_06'] = pd.read_feather(data_dir + 'edge_data_06_shipping_distance.feather')  # Index = Shipping terminal names (export), Columns = Shipping terminal names (import), Values = Distance [km]

    data['node_data_cH2_shipping_terminals_07'] = gpd.read_feather(data_dir + 'node_data_07_cH2_shipping_terminals_import.feather')  # Index = cH2 Shipping terminal names (import)
    data['node_data_wood_chip_shipping_terminals_07'] = gpd.read_feather(data_dir + 'node_data_07_wc_shipping_terminals_import.feather')  # Index = Wood chip shipping terminal names (import)

    if plot_nodes:
        data['edge_data_timber_trucking_route_02'] = gpd.read_feather(data_dir + 'edge_data_02_transport_timber_from_forest_to_gasification_hub_' + RUN_ID + '_driving_route.feather')  # Indices = (Biomass Nodes, Gasification Hubs), Geometry = Route as LineString
        data['edge_data_cH2_trucking_route_04'] = gpd.read_feather(data_dir + 'edge_data_04_transport_cH2_from_biomass_gasifier_to_cH2_shipping_terminal_0_driving_route.feather')  # Indices = (Gasification Hubs, cH2 shipping terminals), Geometry = Route as LineString
        data['edge_data_timber_trucking_route_04'] = gpd.read_feather(data_dir + 'edge_data_04_transport_timber_from_forest_to_wc_shipping_terminal_' + RUN_ID + '_driving_route.feather')  # Indices = (Biomass Nodes, Wood chip shipping terminals), Geometry = Route as LineString
        data['edge_data_shipping_paths_06'] = gpd.read_feather(data_dir + 'edge_data_06_shipping_path.feather')  # Index = (export terminal, import terminal), Geometry = Route as LineString

    # Sensitivity
    # perform_sensitivity_of_shipping_terminal_utilization_on_h2_demand(copy.deepcopy(data), pdir, 50)
    # perform_sensitivity_of_specific_costs_on_hydrogen_demand(copy.deepcopy(data), pdir, 50)
    # compare_sc_branches_cost_emissions(copy.deepcopy(data), pdir)
    # compare_sc_branches_shipping_costs(copy.deepcopy(data), pdir)
    # perform_pareto_sensitivity_bar(copy.deepcopy(data), pdir, 10)
    # exit()

    # Run base case optimization
    case_name = 'Base Case'
    final_hydrogen_demand_mw = 400
    final_hydrogen_demand_kta = final_hydrogen_demand_mw / 100 * 26.2975

    # Initialize metadata
    data['metadata'] = initialize_metadata(metadata, final_hydrogen_demand_mw, 600)

    model = run_optimization(data, final_hydrogen_demand_kta, print_details=False, enforce_cH2_export=False, test_mode=False, show_regression=False)
    print('Time passed: {:.2f} seconds\n'.format(time.time() - start_time))

    total_cost, _, _ = perform_analysis(data, model, RUN_ID, final_hydrogen_demand_kta, write_results=True, plot_nodes=plot_nodes, generate_bar_charts=False, pprint_variables=False, case_name=case_name)
    print('Time passed: {:.2f} seconds\n'.format(time.time() - start_time))