#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Calculate the internal meta parameters based on the input metaparameter file
#################################################################################################################################################################################################################################################

import numpy as np

def initialize_metadata(metadata, final_hydrogen_demand_mw, shipping_distance):
    """
    :param metadata: The metadata dataset as it is read from the input file
    :param final_hydrogen_demand_mw: Supply chain throughput [MW]
    :param shipping_distance: Average expected shipping distance (one-way) [km]
    :return:
    """

    final_hydrogen_demand_kgh = final_hydrogen_demand_mw / 50 * 1501

    # Note: The relations for transfer time are only valid in a single terminal to single terminal case
    ship_size = np.ceil(0.733 * final_hydrogen_demand_mw + 0.219 * shipping_distance * 2 - 15.76) # [#modules]
    filling_time = ship_size * metadata['cH2 Ship Payload per module [kgH2]'] / final_hydrogen_demand_kgh * 60 - 30 # [min]
    emptying_time = -0.311 * final_hydrogen_demand_mw + 0.173 * ship_size + 175.3 # [min]

    metadata['cH2 Ship Num Modules [-]'] = ship_size
    metadata['cH2 Shipping Terminal (export) Filling time [min]'] = filling_time
    metadata['cH2 Shipping Terminal (import) Emptying time [min]'] = emptying_time
    metadata['cH2 Ship Deadweight Tonnage [tonnes] (internal)'] = 5.66 * ship_size
    metadata['cH2 Ship Gross Tonnage [-] (internal)'] = metadata['cH2 Ship Deadweight Tonnage [tonnes] (internal)'] * 0.703

    return metadata