#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Transport constraint for cH2 inland transport
#################################################################################################################################################################################################################################################

import pyomo.environ as pyo

def implement_ch2_pipeline_transport_constraint(model, data):
    """
    Constraint: If the source and destination are on the same place (i.e., less than 5k apart), pipeline transport is feasible
    :param model: Pyomo model
    :param data: The dataset dictionary containing node and edge data
    :return: None
    """

    edge_data_distance_04 = data['edge_data_cH2_trucking_distance_04']  # Indices = Gasification Hubs, Columns = cH2 Shipping Terminals, Values = Distance [m]

    import_indices = model.gasification_hubs_indices_03  # The indices of the nodes which are connected upstream
    export_indices = model.cH2_shipping_terminal_indices_05  # The indices of the nodes which are connected downstream
    model.cH2_pipeline_transport_constraint_04 = pyo.Constraint(import_indices, export_indices, rule=lambda model, import_index, export_index: transport_constraint(model, import_index, export_index, edge_data_distance_04))


def transport_constraint(model, import_index, export_index, edge_data_distance_04):

    bigM = 10e3 # [kt hydrogen per year]
    transport_distance = edge_data_distance_04.loc[import_index, export_index]

    return model.edges_ch2_pipeline_amount_04[import_index, export_index] <= (transport_distance < 5000) * bigM