#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Create nodes where shipping terminals could be built (import)
#################################################################################################################################################################################################################################################


################################################################################################################################
# IMPORT
import time
import os
import folium
import webbrowser
import pandas as pd
import geopandas as gpd
from shapely import Point
from shapely.ops import transform as shapely_transform
from pyproj import Transformer
pd.options.mode.chained_assignment = None

start_time = time.time()
################################################################################################################################


################################################################################################################################
print('Time passed: {:.2f} seconds'.format(time.time() - start_time))
################################################################################################################################


################################################################################################################################

################################################################################################
# Select tettsteder that could be potential places for building shipping terminals

terminal_location = [8.11253, 53.52998] # CRS 4326

transformer_4326_to_25833 = Transformer.from_crs("EPSG:4326", "EPSG:25833", always_xy=True)
terminal_location_25833 = shapely_transform(transformer_4326_to_25833.transform, Point(terminal_location))

gdf_shipping_terminals = pd.DataFrame(data={'geometry': [terminal_location_25833], 'geometry_4326':[terminal_location]}, index=['Wilhelmshaven'])
gdf_shipping_terminals = gpd.GeoDataFrame(gdf_shipping_terminals, geometry=gdf_shipping_terminals['geometry'], crs="EPSG:25833")

m = folium.Map(tiles="cartodb positron")
_ = gdf_shipping_terminals.apply(lambda row: folium.Marker(location=tuple(reversed(row['geometry_4326'])), icon=folium.Icon(color='black', icon_color='black'), tooltip=row.name).add_to(m), axis=1)

plot_name = 'possible_wc_shipping_terminals (import)'
m.save('plots/' + plot_name + ".html")
webbrowser.open_new_tab(os.getcwd() + '/plots/' + plot_name + ".html")

# Export
gdf_shipping_terminals.to_feather('output_data/node_data_07_wc_shipping_terminals_import.feather')
################################################################################################

################################################################################################################################