#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Create nodes of shipping terminals for timber
#################################################################################################################################################################################################################################################


################################################################################################################################
# IMPORT
import geopandas as gpd
import time
import os
import folium
import webbrowser
import pandas as pd
import numpy as np
from pyproj import Transformer
from shapely.ops import transform as shapely_transform
from shapely import Point
pd.options.mode.chained_assignment = None

start_time = time.time()
################################################################################################################################


################################################################################################################################
print('Importing data')

# Import datasets
gdf_shipping_terminals = pd.read_excel('input_data/timber shipping terminals.xlsx', sheet_name='Overview', index_col=0)

gdf_fylkedata = gpd.read_feather('../X_GLOBAL/data_processed/dataset_fylke.feather')
timber_price = pd.read_excel('../X_GLOBAL/data_processed/dataset_landsdeler.xlsx', sheet_name='skog_data', index_col=0).loc[:,'Timber price [NOK2023/m3]']
electricity_price = pd.read_excel('../X_GLOBAL/data_processed/dataset_landsdeler.xlsx', sheet_name='electricity_price', index_col=0).loc[:,'Sum [NOK2024/MWh]']
gdf_electricity_zones = gpd.read_feather('../X_GLOBAL/data_processed/dataset_electricity_zones.feather')

print('Time passed: {:.2f} seconds'.format(time.time() - start_time))
################################################################################################################################


################################################################################################################################

gdf_shipping_terminals['Coordinates'] = gdf_shipping_terminals[['Coordinates']].map(lambda el: np.array(list(reversed(eval(el)))))

transformer_4326_to_25833 = Transformer.from_crs("EPSG:4326", "EPSG:25833", always_xy=True)
_ = gdf_shipping_terminals[['Coordinates']].map(lambda el: shapely_transform(transformer_4326_to_25833.transform, Point(el))).rename(columns={'Coordinates': 'geometry'})
gdf_shipping_terminals = pd.concat([gdf_shipping_terminals, _], axis=1)
gdf_shipping_terminals = gpd.GeoDataFrame(gdf_shipping_terminals, geometry=gdf_shipping_terminals['geometry'], crs="EPSG:25833")
gdf_shipping_terminals = gpd.sjoin(gdf_shipping_terminals, gdf_fylkedata[['geometry', 'landsdel']], how='left', predicate='within')

_ = gdf_shipping_terminals[['landsdel']].map(lambda el: timber_price[el]).rename(columns={'landsdel': 'Timber price [NOK2023/m3]'})
gdf_shipping_terminals = pd.concat([gdf_shipping_terminals, _], axis=1)

gdf_shipping_terminals = gpd.sjoin(gdf_shipping_terminals, gdf_electricity_zones, how='left', predicate='within')
_ = gdf_shipping_terminals[['ElSpotOmr']].map(lambda el: electricity_price[el]).rename(columns={'ElSpotOmr': 'Electricity price [NOK2024/MWh]'})
gdf_shipping_terminals = pd.concat([gdf_shipping_terminals, _], axis=1)

gdf_shipping_terminals.rename(columns={'Coordinates':'geometry_4326'}, inplace=True)

# Plot selected terminals
m = folium.Map(tiles="cartodb positron")
_ = gdf_shipping_terminals.apply(lambda row: folium.Marker(location=tuple(reversed(row['geometry_4326'])), icon=folium.Icon(color='black', icon_color='black'), tooltip=row.name).add_to(m), axis=1)

plot_name = 'possible_wc_shipping_terminals (export)'
m.save('plots/' + plot_name + ".html")
webbrowser.open_new_tab(os.getcwd() + '/plots/' + plot_name + ".html")

# Export
gdf_shipping_terminals.to_feather('output_data/node_data_05_wc_shipping_terminals_export.feather')

################################################################################################################################