#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Create plots for biomass nodes
#################################################################################################################################################################################################################################################

################################################################################################################################
# IMPORT
import geopandas as gpd
import matplotlib.pyplot as plt
import time
import json

start_time = time.time()
################################################################################################################################


################################################################################################################################
# IMPORT FILES
print('### DATA IMPORT ###')

RID = '141D216220'

with open('../X_GLOBAL/data_processed/crs.json', 'r') as openfile:
    base_crs = json.load(openfile)

df_productive_forest = gpd.read_feather('../X_GLOBAL/data_processed/dataset_x16_skog_productive.feather')
df_reduced_centers = gpd.read_feather('../nodes_primary_biomass_resources/output_data/node_data_01_biomass_' + RID + '.feather')
df_fylkedata = gpd.read_feather('../X_GLOBAL/data_processed/dataset_fylke.feather')

# Check consistency
for df in [df_productive_forest, df_reduced_centers, df_fylkedata]:
    if df.crs != base_crs:
        print('INFORMATION: Different crs detected!')
        df.to_crs(base_crs, inplace=True)

print('Time passed: {:.2f} seconds'.format(time.time() - start_time))
################################################################################################################################


################################################################################################################################
# Calculate
print('\n### PLOTTING ###')

#######################################################################################################
# Plot productive forest area and reduced centroids, sized to potential

ax = df_productive_forest.plot(figsize=(20, 20), color='#88db8c')
df_reduced_centers.plot(ax=ax, color='k', markersize=df_reduced_centers['Potential [1000m3]'])

plt.xticks([])
plt.yticks([])
plt.xlabel('Longitude')
plt.ylabel('Latitude')
plt.title('Productive forest areas and the chosen centroids')
plt.savefig('outputs/04_skog_productive_and_centroids, sized to potential.png', dpi=600)
#######################################################################################################

#######################################################################################################
# Plot productive forest area and reduced centroids, sized to production costs

ax = df_productive_forest.plot(figsize=(20, 20), color='#88db8c')
df_reduced_centers.plot(ax=ax, color='k', markersize=df_reduced_centers['Production costs [NOK/m3]'])

plt.xticks([])
plt.yticks([])
plt.xlabel('Longitude')
plt.ylabel('Latitude')
plt.title('Productive forest areas and the chosen centroids')
plt.savefig('outputs/04_skog_productive_and_centroids, sized to production costs.png', dpi=600)
#######################################################################################################

print('Time passed: {:.2f} seconds'.format(time.time() - start_time))