#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Read and process data. This has to be done once!
#################################################################################################################################################################################################################################################

################################################################################################################################
# IMPORT
import geopandas as gpd
import time
import numpy as np
################################################################################################################################


################################################################################################################################
# IMPORT FILES

start_time = time.time()

data_dir_in = '../X_GLOBAL/data_raw/biomass/'
data_dir_out = '../X_GLOBAL/data_processed/'

gdf_vern = gpd.read_file(data_dir_in + 'Vern_0000_norge_25833_FILEGDB.gdb', layer='Naturvernområde')
gdf_x16 = gpd.read_file(data_dir_in + '0000_25833_SR16_GDB.gdb')

if gdf_x16.crs != gdf_vern.crs:
    print('INFORMATION: Different crs at x16 and vern datasets!')
    gdf_vern = gdf_vern.to_crs(gdf_x16.crs)

print('Time passed: {:.2f} seconds'.format(time.time() - start_time))

################################################################################################################################


################################################################################################################################
# Calculate

gdf_vern = gdf_vern[np.logical_or(gdf_vern['verneform'] == 'naturreservat', gdf_vern['verneform'] == 'nasjonalpark')] # Select protected areas
df_productive_forest = gpd.overlay(gdf_x16, gdf_vern, how='difference') # Select not-protected areas

print('Time passed: {:.2f} seconds'.format(time.time() - start_time))
################################################################################################################################


################################################################################################################################
# Export

df_productive_forest.to_feather('processed_data/dataset_x16_skog_productive.feather')
df_productive_forest.iloc[0:100,:].to_excel('processed_data/dataset_x16_skog_productive_small.xlsx')

gdf_vern.to_feather(data_dir_out + 'dataset_vern.feather')
gdf_x16.to_feather(data_dir_out + 'dataset_x16.feather')
