#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Create geodataframe for the counties and their landsdel. This has to be done once!
#################################################################################################################################################################################################################################################

################################################################################################################################
# IMPORT
import geopandas as gpd
import time
from pyproj import CRS
import json
################################################################################################################################


################################################################################################################################
# IMPORT FILES

start_time = time.time()

data_dir_in = '../X_GLOBAL/data_raw/general/'
data_dir_out = '../X_GLOBAL/data_processed/'

gdf_fylkedata = gpd.read_file(data_dir_in + 'Basisdata_0000_Norge_25833_Fylker_FGDB.gdb')

with open(data_dir_out + 'crs.json', 'r') as openfile:
    base_crs = CRS(json.load(openfile))

if gdf_fylkedata.crs != base_crs:
    print('Converting CRS of fylke dataset to base CRS!')
    gdf_fylkedata.to_crs(base_crs)

print('Time passed: {:.2f} seconds'.format(time.time() - start_time))
################################################################################################################################


################################################################################################################################
# Calculate

gdf_fylkedata.index=gdf_fylkedata['fylkesnummer']
gdf_fylkedata = gdf_fylkedata[['fylkesnavn', 'geometry']]

gdf_fylkedata['landsdel'] = ''
gdf_fylkedata.loc[['15', '46', '11'], 'landsdel'] = 'Vestlandet'
gdf_fylkedata.loc[['33', '32', '31', '03'], 'landsdel'] = 'Viken og Oslo'
gdf_fylkedata.loc[['34'], 'landsdel'] = 'Innlandet'
gdf_fylkedata.loc[['39', '40'], 'landsdel'] = 'Vestfold og Telemark'
gdf_fylkedata.loc[['42'], 'landsdel'] = 'Agder'
gdf_fylkedata.loc[['50'], 'landsdel'] = 'Trøndelag'
gdf_fylkedata.loc[['18'], 'landsdel'] = 'Nordland'
gdf_fylkedata.loc[['55', '56'], 'landsdel'] = 'Troms og Finnmark'

print('Time passed: {:.2f} seconds'.format(time.time() - start_time))
################################################################################################################################


################################################################################################################################
# Export

gdf_fylkedata.to_feather(data_dir_out + 'dataset_fylke.feather')
