#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Create geodataframe for the coastline of Norway. This has to be done once!
#################################################################################################################################################################################################################################################

################################################################################################################################
# IMPORT
import geopandas as gpd
import time
from pyproj import CRS
import json
from input_calculations.X_GLOBAL_SCRIPTS import helper_functions as hf
################################################################################################################################


################################################################################################################################
# IMPORT FILES

start_time = time.time()

data_dir_in = '../X_GLOBAL/data_raw/general/'
data_dir_out = '../X_GLOBAL/data_processed/'

gdf_seadata = gpd.read_file(data_dir_in + 'fjordkatalogen_omrade.zip') #https://kartkatalog.miljodirektoratet.no/Dataset/Details/501

with open(data_dir_out + '/crs.json', 'r') as openfile:
    base_crs = CRS(json.load(openfile))

if gdf_seadata.crs != base_crs:
    print('Converting CRS of fylke dataset to base CRS!')
    gdf_seadata.to_crs(base_crs, inplace=True)

print('Time passed: {:.2f} seconds'.format(time.time() - start_time))
################################################################################################################################


################################################################################################################################
# Calculate

gdf_seadata = gdf_seadata[['navn', 'geometry']]
hf.plot_selected_geodataframe(gdf_seadata, 'coastline_norway', folder='plots/')

print('Time passed: {:.2f} seconds'.format(time.time() - start_time))
################################################################################################################################


################################################################################################################################
# Export

gdf_seadata.to_feather(data_dir_out + 'dataset_coastline.feather')