#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Task: Run all files for data generation in the correct order
# Note: Docker must be running when this file is executed!
#################################################################################################################################################################################################################################################


# IMPORTS
from nodes_primary_biomass_resources.create_biomass_nodes import run as create_biomass_nodes
from edges_inland_transport.create_transport_matrix import run as create_inland_transport_matrix
from edges_shipping_transport.create_transport_matrix import create_shipping_matrix
import os
import geopandas as gpd
import time
import pandas as pd
import warnings

warnings.simplefilter(action='ignore', category=pd.errors.PerformanceWarning) # Allocating distance, driving time to dataframe not time effective, but the other code takes much longer so ignore


if __name__ == '__main__':
    start_time = time.time()
    pdir = os.getcwd() + '\\'

    RUN_ID = 'BC'

    # Check that everything is ready
    assert os.path.exists('nodes_secondary_biomass_gasification/output_data/node_data_03_biomass_gasification.feather'), 'Create nodes for biomass gasification hubs first!'
    assert os.path.exists('nodes_tertiary_cH2_shipping_terminal_export/output_data/node_data_05_cH2_shipping_terminals_export.feather'), 'Create nodes for cH2 shipping terminals first!'
    assert os.path.exists('nodes_tertiary_cH2_shipping_terminal_import/output_data/node_data_07_cH2_shipping_terminals_import.feather'), 'Create nodes for cH2 shipping terminals first!'
    assert os.path.exists('nodes_tertiary_wc_shipping_terminal_export/output_data/node_data_05_wc_shipping_terminals_export.feather'), 'Create nodes for wood chip shipping terminals first!'
    assert os.path.exists('nodes_tertiary_wc_shipping_terminal_import/output_data/node_data_07_wc_shipping_terminals_import.feather'), 'Create nodes for wood chip shipping terminals first!'


    ### Node level 1 - Create nodes if they do not exist ###
    if os.path.exists('nodes_primary_biomass_resources/output_data/node_data_01_biomass_{}.feather'.format(RUN_ID)):
        print('Biomass node data already exists, reading existing file')
    else:
        print('Biomass node data does not exist, creating new file')
        create_biomass_nodes(RUN_ID, 1000, pdir, plot_nodes=True)

    gdf_biomass_resources = gpd.read_feather('nodes_primary_biomass_resources/output_data/node_data_01_biomass_{}.feather'.format(RUN_ID))


    ### Node level 3 - Read nodes ###
    gdf_biomass_gasification_hubs = gpd.read_feather('nodes_secondary_biomass_gasification/output_data/node_data_03_biomass_gasification.feather')


    ### Node level 5 - Read nodes ###
    gdf_cH2_shipping_terminals_export = gpd.read_feather('nodes_tertiary_cH2_shipping_terminal_export/output_data/node_data_05_cH2_shipping_terminals_export.feather')
    gdf_wc_shipping_terminals_export = gpd.read_feather('nodes_tertiary_wc_shipping_terminal_export/output_data/node_data_05_wc_shipping_terminals_export.feather')


    ### Node level 7 - Read nodes ###
    gdf_cH2_shipping_terminals_import = gpd.read_feather('nodes_tertiary_cH2_shipping_terminal_import/output_data/node_data_07_cH2_shipping_terminals_import.feather')
    gdf_wc_shipping_terminals_import = gpd.read_feather('nodes_tertiary_wc_shipping_terminal_import/output_data/node_data_07_wc_shipping_terminals_import.feather')


    ### Create edges between NL1 and NL3 ###
    edge_name = 'edge_data_02_transport_timber_from_forest_to_gasification_hub'
    
    if not os.path.exists('edges_inland_transport/output_data/{}_{}_distance.feather'.format(edge_name, RUN_ID)):
        print('CREATING EDGES: BIOMASS NODES -> BIOMASS GASIFICATION HUBS')

        gdf_biomass_resources['geometry'] = gdf_biomass_resources['point_on_closest_road']  # Use road point as start for transport calculation
        create_inland_transport_matrix(RUN_ID, gdf_biomass_resources, gdf_biomass_gasification_hubs, edge_name, (True, True), pdir, debug=False, plot_distributions=True)

    
    ### Create edges between NL3 and NL5 ###
    # Superstructure for gasification hubs and shipping terminals is the same for all Run IDs -> Run ID 0
    
    edge_name = 'edge_data_04_transport_cH2_from_biomass_gasifier_to_cH2_shipping_terminal'
    if not os.path.exists('edges_inland_transport/output_data/{}_0_distance.feather'.format(edge_name)):
        print('CREATING EDGES: BIOMASS GASIFICATION HUBS -> cH2 SHIPPING TERMINALS (EXPORT)')

        create_inland_transport_matrix('0', gdf_biomass_gasification_hubs, gdf_cH2_shipping_terminals_export, edge_name,(True, True), pdir, debug=False, plot_distributions=False)

    edge_name = 'edge_data_04_transport_timber_from_forest_to_wc_shipping_terminal'
    if not os.path.exists('edges_inland_transport/output_data/{}_{}_distance.feather'.format(edge_name, RUN_ID)):
        print('CREATING EDGES: BIOMASS NODES -> WC SHIPPING TERMINALS (EXPORT)')

        gdf_biomass_resources['geometry'] = gdf_biomass_resources['point_on_closest_road']  # Use road point as start for transport calculation
        create_inland_transport_matrix(RUN_ID, gdf_biomass_resources, gdf_wc_shipping_terminals_export, edge_name, (True, True), pdir, debug=False, plot_distributions=False)

    
    # 7. Create edges between NL5 and NL7 (append possible new entries to existing routes)

    gdf_coastline = gpd.read_feather('X_GLOBAL/data_processed/dataset_coastline.feather')
    edge_name = 'edge_data_06_shipping'

    print('\nCREATING EDGES: cH2 SHIPPING TERMINALS (EXPORT) -> cH2 SHIPPING TERMINALS (IMPORT)')
    create_shipping_matrix(gdf_cH2_shipping_terminals_export, gdf_cH2_shipping_terminals_import, edge_name, gdf_coastline, pdir, append=True, save_path=True)

    print('\nCREATING EDGES: wc SHIPPING TERMINALS (EXPORT) -> wc SHIPPING TERMINALS (IMPORT)')
    create_shipping_matrix(gdf_wc_shipping_terminals_export, gdf_wc_shipping_terminals_import, edge_name, gdf_coastline, pdir, append=True, save_path=True)

    print('\nTime passed: {:.2f} seconds'.format(time.time() - start_time))
    ################################################################################################################################