#################################################################################################################################################################################################################################################
# AUTHOR: Matthias Maier
# Structure: The transport matrix contains values for transport from A (index value) to B (colum value)
# Units:
#     Distance: m
#     Driving time: sec
#     Search radius: m
#     Cost: NOK2024/t
#################################################################################################################################################################################################################################################


# IMPORTS
import pandas as pd
import numpy as np
import warnings

warnings.simplefilter(action='ignore', category=pd.errors.PerformanceWarning) # Allocating distance, driving time to dataframe not time effective, but rests takes much longer so ignore

if __name__ == '__main__':

    run_id = 'BC'

    # Timber truck
    edge_names = ['edge_data_02_transport_timber_from_forest_to_gasification_hub', 'edge_data_04_transport_timber_from_forest_to_wc_shipping_terminal']
    speeds = []

    for edge_name in edge_names:
            df_transport_distance = pd.read_feather('../edges_inland_transport/output_data/{}_{}_distance.feather'.format(edge_name, run_id))  # Index = Start, Columns = Destination
            df_transport_driving_time = pd.read_feather('../edges_inland_transport/output_data/{}_{}_driving_time.feather'.format(edge_name, run_id))  # Index = Start, Columns = Destination

            for index_start in df_transport_distance.index:
                for index_destination in df_transport_distance.columns.values:
                    driving_time = df_transport_driving_time.loc[index_start, index_destination] / 3600  # One-way trip time [h]
                    distance = df_transport_distance.loc[index_start, index_destination]  # One-way trip distance [m]

                    if distance < 5000:
                        continue

                    speed = distance / 1000 / driving_time
                    speeds.append(speed)

    mean = np.array(speeds).mean()
    print(mean)

    # cH2 Tube Trailer
    edge_name = 'edge_data_04_transport_cH2_from_biomass_gasifier_to_cH2_shipping_terminal'
    speeds = []

    df_transport_distance = pd.read_feather('../edges_inland_transport/output_data/{}_0_distance.feather'.format(edge_name))  # Index = Start, Columns = Destination
    df_transport_driving_time = pd.read_feather('../edges_inland_transport/output_data/{}_0_driving_time.feather'.format(edge_name))  # Index = Start, Columns = Destination

    for index_start in df_transport_distance.index:
        for index_destination in df_transport_distance.columns.values:

            driving_time = df_transport_driving_time.loc[index_start, index_destination] / 3600  # One-way trip time [h]
            distance = df_transport_distance.loc[index_start, index_destination]  # One-way trip distance [m]

            if distance < 5000:
                continue

            speed = distance / 1000 / driving_time
            speeds.append(speed)

    mean = np.array(speeds).mean()
    print(mean)
#################################################################################################################################################################################################################################################