from CoolProp.CoolProp import PropsSI

# Z value
Z = PropsSI('Z', 'T', 293.2,'P',45*100*1000, 'Hydrogen')
print('Z: {:.4f}'.format(Z))

# Density at temperature and pressure
RHO = PropsSI('DMASS', 'T', 273.15+20,'P',250*100*1000, 'Hydrogen')
print('RHO: {:.4f} kg/m3'.format(RHO))

# Pressure at temperature and density
p = PropsSI('P', 'T', 273.15+43.2,'DMASS',RHO, 'Hydrogen')
print('p: {:.4f} bar'.format(p/100000))

# Isenthalpic expansion
h_start = PropsSI('H', 'T', 293.15,'P',350*100*1000, 'Hydrogen')
t_end = PropsSI('T', 'H', h_start,'P',1*100*1000, 'Hydrogen')
print('T_end: {:.4f} C'.format(t_end-273.15))

# Isochoric cooling
rho_start = PropsSI('DMASS', 'T', 273.15+67.1,'P',350*100*1000, 'Hydrogen')
p_end = PropsSI('P', 'T', 273.15+20,'DMASS',rho_start, 'Hydrogen')
print('P_end: {:.4f} bar'.format(p_end/100000))

# Temperature decrease at isentropic expansion
s_start = PropsSI('S', 'T', 273.15+20,'P',350*100*1000, 'Hydrogen')
t_end = PropsSI('T', 'S', s_start,'P',20*100*1000, 'Hydrogen')
print('T_end: {:.4f} C'.format(t_end-273.15))
print('W: {:.4f} kJ/kg'.format((PropsSI('H', 'S', s_start,'P',350*100*1000, 'Hydrogen')- PropsSI('H', 'S', s_start,'P',20*100*1000, 'Hydrogen'))/1000))